/*
 * SAXTest.h
 *
 * header file for SAXTest
 *
 * This wizard-generated code is based on code adapted from the
 * stationery files distributed as part of the Palm OS SDK 4.0.
 *
 * Copyright (c) 1999-2000 Palm, Inc. or its subsidiaries.
 * All rights reserved.
 */
 
#ifndef SAXTEST_H_
#define SAXTEST_H_

/*********************************************************************
 * Internal Structures
 *********************************************************************/


/*********************************************************************
 * Global variables
 *********************************************************************/
extern UInt16	g_libRef;
extern MemHandle	g_ParseStatus;

Boolean	FP_OpenFile(Char* uri,UInt32 *pFileRef); /* Opens the file */
UInt16	FP_GetFileBlockSize(UInt32 fileRef); /* Gets file block size */
Boolean	FP_ReadFile(UInt32 fileRef,void *pBuf,UInt16 *readBytes); /* Reads the next file block contents to the buffer */
void	FP_CloseFile(UInt32 fileRef); /* Closes the opened file */
Boolean	FP_SeekFile(UInt32 fileRef,Int32 *offset); /* Seeks to the specific position in the file */
UInt32	FP_GetFileSize(UInt32 fileRef); /* Returns the file size */


void CH_StartElement(Char* uri,Char* localName,Char* qName,UInt32 attrID);
void CH_EndElement(Char* uri,Char* localName,Char* qName);
Boolean CH_Characters(Char* ch,Int16 start,Int16 length,UInt32 currentState);
void CH_SetDocumentLocator(UInt32 locatorID);
void CH_EndDocument();
/*********************************************************************
 * Internal Constants
 *********************************************************************/

#define appFileCreator			'SAXt'
#define appName					"SAXTest"
#define appVersionNum			0x01
#define appPrefID				0x00
#define appPrefVersionNum		0x01

#endif /* SAXTEST_H_ */
